<?php
include_once 'db.php';  

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

date_default_timezone_set("Asia/Calcutta");
$currentDate = date('Y-m-d');  

// Decode JSON input from AJAX
$requestData = json_decode(file_get_contents('php://input'), true);

if (!$requestData) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid data received.']);
    exit;
}

// Extract customer details
$userid = $requestData['user_id'] ?? '';
$email = $requestData['email'] ?? '';
$firstName = $requestData['firstName'] ?? '';
$lastName = $requestData['lastName'] ?? '';
$phoneNumber = $requestData['phoneNumber'] ?? '';
$address = $requestData['address'] ?? '';
$apartment = $requestData['apartment'] ?? '';
$city = $requestData['city'] ?? '';
$postalCode = $requestData['postalCode'] ?? '';
$totalAmount = $requestData['totalAmount'] ?? 0;
$gstno = $requestData['gstno'] ?? '';
$payment_id = $requestData['razorpay_payment_id'] ?? '';
$shipping = $requestData['shipping'] ?? '';
$payment_method = $requestData['payment_method'] ?? 'online'; 
$totalDiscount = $requestData['totalDiscount'] ?? 0;
$ordernote= $requestData['orderNotes'] ?? '';

$saddress = $apartment . ' ' . $address;
$name = $firstName . ' ' . $lastName;

// Fetch or insert customer data
$selectCustomer = "SELECT id AS customerid, displayname, address, address2, city, pincode, 
                          saddress, scity, spincode, sphoneno, sname 
                   FROM customer 
                   WHERE email = '$email'";
$customerResult = mysqli_query($conn, $selectCustomer);
$customerRow = mysqli_fetch_assoc($customerResult);

if ($customerRow) {
    $customerid = $customerRow['customerid'];
    $displayname = $customerRow['displayname'];
    
    $currentBillingAddress = trim($customerRow['address'] . ' ' . $customerRow['address2']);
    $newBillingAddress = trim($apartment . ' ' . $address);
    
    $addressChanged = (
        $currentBillingAddress != $newBillingAddress ||
        $customerRow['city'] != $city ||
        $customerRow['pincode'] != $postalCode ||
        $customerRow['saddress'] != $saddress ||
        $customerRow['scity'] != $city ||
        $customerRow['spincode'] != $postalCode ||
        $customerRow['sphoneno'] != $phoneNumber ||
        $customerRow['sname'] != $name
    );

    if ($addressChanged) {
        $updateCustomer = "UPDATE customer SET 
                          address = '$apartment',
                          address2 = '$address',
                          city = '$city',
                          pincode = '$postalCode',
                          saddress = '$saddress',
                          scity = '$city',
                          spincode = '$postalCode',
                          sphoneno = '$phoneNumber',
                          sname = '$name'
                          WHERE id = '$customerid'";
        mysqli_query($conn, $updateCustomer);
    }
}

// Generate new order ID
$lastOrderQuery = "SELECT order_no FROM orders ORDER BY Order_id DESC LIMIT 1";
$lastOrderResult = mysqli_query($conn, $lastOrderQuery);
$lastOrder = mysqli_fetch_assoc($lastOrderResult);
$orderid = $lastOrder['order_no'] ?? 'ORD-001';
$orderNumberParts = explode("-", $orderid);
$newOrderID = 'ORD-' . str_pad((int)$orderNumberParts[1] + 1, 5, "0", STR_PAD_LEFT);

// Handle payment methods
if ($payment_method === 'COD') {
    $insertOrder = "INSERT INTO orders (user_id, displayname, order_no, Balance, Grand_total, Action_status, Created_date, Confirmed_date, Store_status, Payment_status,Shipping,Total_saving,prebooked,ordernote)
                    VALUES ('$customerid', '$displayname', '$newOrderID', '$totalAmount', '$totalAmount', '7', '$currentDate', '$currentDate', '2', '0','$shipping','$totalDiscount','1','$ordernote')";
    mysqli_query($conn, $insertOrder);
    $orderid = mysqli_insert_id($conn);
} else {
    $insertOrder = "INSERT INTO orders (user_id, displayname, order_no, Balance, Grand_total, Action_status, Created_date, Confirmed_date, Store_status, Payment_status,Shipping,Total_saving,prebooked)
                    VALUES ('$customerid', '$displayname', '$newOrderID', '0', '$totalAmount', '1', '$currentDate', '$currentDate', '2', '1','$shipping','$totalDiscount','1')";
    mysqli_query($conn, $insertOrder);
    $orderid = mysqli_insert_id($conn);
    
    $invoiceid = 'INV-' . str_pad($orderid, 5, "0", STR_PAD_LEFT);
    $updatepayment = "INSERT INTO payment (customer_id, Order_id, Invoice_id, Amount, Payment_amount, Payment_type, note, Payment_date, Reference_id)
                      VALUES ('$customerid', '$orderid', '$invoiceid', '$totalAmount', '$totalAmount', 'razorpay', 'online order', '$currentDate', '$payment_id')";
    mysqli_query($conn, $updatepayment);
    $paymentid1 = mysqli_insert_id($conn);
}

// Process products
foreach ($requestData['products'] as $product) {
    $productId = $product['id'];
    $productName = $product['name'];
    $productUnit = $product['quantity'];
    $productPrice = $product['price'];
    $Tax = $product['tax'];
    $Tax_percentage = $product['tax_percentage'];
    $Discount = $product['discount'];
    $Discount_percentage = $product['discount_percentage'];
    $mrp = str_replace('₹', '', $product['mrp']); 
    $productSubtotal = $product['subtotal'];
    $weight = $product['unit'];

    $insertProduct = "INSERT INTO order_data (Order_id, Product_id, qty, Selling_price,discount,Discount_percentage, MRP, Tax,Tax_percentage, Product_total)
                      VALUES ('$orderid', '$productId', '$productUnit', '$productPrice','$Discount','$Discount_percentage', '$mrp','$Tax','$Tax_percentage', '$productSubtotal')";
    mysqli_query($conn, $insertProduct);

    $update_product_query = "UPDATE product SET qty = qty - '$productUnit' WHERE Product_id = '$productId'";
    mysqli_query($conn, $update_product_query);
    
    $update_inventory_query = "UPDATE inventory SET Qty = Qty - '$productUnit', date_modified = NOW() WHERE Product_id = '$productId'";
    mysqli_query($conn, $update_inventory_query);
}

// Send email confirmation
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host       = 'smtp.gmail.com';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'novaronald023@gmail.com';
    $mail->Password   = 'tdow bdbv dsnd xqxe';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 587;

    $mail->setFrom('novaronald023@gmail.com', 'RF GHEE');
    $mail->addAddress($email, $name);
    $mail->addAddress('novaronald023@gmail.com', $name);

    $mail->Subject = ' Pre-Booking Confirmed - You`ve Locked In the Best Price!';
    $html .='<h2>Thank you for pre-booking with STS Steels!</h2>';
    $html .= '<p>Dear ' . $name . '</p>';
      $html .= '<p>We`re happy to confirm that we`ve received your pre-booking order #' . $newOrderID .' along with your payment of Rs: '. $totalAmount . '</p>';
    $html .= '<p>Your early booking has secured you a <strong>better price</strong> ahead of the recent market rate surge - a smart move! </p>';
    $html .= '<h3>Order Details</h3>';
    $html .= '<table border="1" cellpadding="10"><tr><th>Product Name</th><th>Quantity</th><th>Price in Rupees</th></tr>';
    foreach ($requestData['products'] as $product) {
      $html .= '<tr><td>' . $product['name'] . '</td><td>' . $product['quantity'] . '</td><td>' . preg_replace('/[^0-9.]/', '', $product['mrp']) . '</td></tr>';
    }
    $html .= '</table>';
    $html .= '<p>Total : ' . $totalAmount . '</p>';
      $paymentQuery = "SELECT Payment_amount, Payment_type FROM payment WHERE Order_id = '$orderid'";
    $paymentResult = mysqli_query($conn, $paymentQuery);
    
    $paymentDetails = '';
    $totalPaid = 0;
    
    if (mysqli_num_rows($paymentResult) > 0) {
        $paymentDetails .= '<table border="1" cellpadding="5" style="margin: 10px 0;">';
        $paymentDetails .= '<tr><th>Amount Paid</th><th>Payment Mode</th></tr>';
        
        while ($paymentRow = mysqli_fetch_assoc($paymentResult)) {
            $paymentDetails .= '<tr>';
            $paymentDetails .= '<td>' . $paymentRow['Payment_amount'] . '</td>';
            $paymentDetails .= '<td>' . ucfirst($paymentRow['Payment_type']) . '</td>';
            $paymentDetails .= '</tr>';
            $totalPaid += $paymentRow['Payment_amount'];
        }
        
        $paymentDetails .= '</table>';
        $paymentDetails .= '<p><strong>Total Paid: Rs. ' . $totalPaid . '</strong></p>';
    }
    $html .= '<p>Booking Date: ' .$currentDate. '</p>';
    $html .='<p><strong>Cancellation Policy:</strong></p>';
    $html .='<p>You may cancel this pre-booking for a full refund <strong>only after 25 days</strong> from the date of booking. Kindly note that cancellations before this period are not eligible for refunds, as we allocate material and pricing in advance.</p>';
    $html .='<br>';
    $html .='<p>We will notify you once your booking moves to dispatch or delivery stage.</p>';
    $html .='<br>';
    $html .='<p>If you have any questions, feel free to reach out at sales@sculptengineering.com (or) 04322-221792</p>';
    $html .='<br>';
    $html .='<p>Once again, congratulations on securing your order early and saving on upcoming price hikes!</p>';
    $html .='<br>';
    $html .='<p>Warm regards,</p>';
    $html .='<p><strong>Team STS Steels</strong></p>';
    $html .='<p>www.stssteels.com</p>';
    $html .='<p>Tel- 04322-221792</p>';
    $mail->msgHTML($html);

    $mail->send();
} catch (Exception $e) {
    error_log("Email could not be sent. Mailer Error: {$mail->ErrorInfo}. Recipient Email: $email");
}

// Return success response
echo json_encode([
    'status' => 'success',
    'message' => 'Order placed successfully.',
    'order_id' => $orderid,
    'order_no' => $newOrderID,
    'grand_total' => $totalAmount
]);
exit;
?>